import matplotlib.pyplot as plt
import numpy as np
import pickle
import plotly.graph_objects as go

with open('cifar100_subset_19_kDN_history_30repeats_random.pkl', 'rb') as file_pi:
    random_history = pickle.load(file_pi)
with open('cifar100_subset_19_kDN_history_30repeats_curriculum.pkl', 'rb') as file_pi:
    curriculum_history = pickle.load(file_pi)
with open('cifar100_subset_19_kDN_history_30repeats_anti.pkl', 'rb') as file_pi:
    anti_history = pickle.load(file_pi)
with open('cifar100_subset_19_kDN_history_30repeats_random.pkl', 'rb') as file_pi:
    curriculum_historySVM = pickle.load(file_pi)
with open('cifar100_subset_19_kDN_history_30repeats_curriculum.pkl', 'rb') as file_pi:
    anti_historySVM = pickle.load(file_pi)
with open('cifar100_subset_19_kDN_history_30repeats_anti.pkl', 'rb') as file_pi:
    random_historySVM = pickle.load(file_pi)


def bar_plot(histories, labels, colors):
    fig = go.Figure()
    trace_list = []

    for history, label, color in zip(histories, labels, colors):

        if 'std_val_acc' in history.keys():
            trace = go.Bar(
                x=[label],
                y=[history['val_acc'][-1]],
                name=label,
                marker_color=color,
                text=['{:.3f} ± {:.3f}'.format(history['val_acc'][-1], history['std_val_acc'][-1])],
                #text=['{:.3f}'.format(history['val_acc'][-1])],
                textposition='outside',
                error_y=dict(
                    type='data', 
                    array=[history['std_val_acc'][-1]],
                    thickness=2,
                    width=20,
                    visible=True),
                showlegend=False #len(histories) > 1
            )
        else:
            trace = go.Bar(
                x=[label],
                y=[history['val_acc'][-1]],
                name=label,
                marker_color=color,
                 #text=['{:.3f} ± {:.3f}'.format(history['val_acc'][-1], history['std_val_acc'][-1])],
                 #text=['{:.3f}'.format(history['val_acc'][-1])],
                 textposition='outside',
                showlegend=False #len(histories) > 1
            )

        trace_list.append(trace)

    fig.add_traces(trace_list)

    # Edição do layout
    fig.update_layout(
        legend=dict(
            font=dict(
                size=14
            )
        )
    )
    
    fig.update_traces(
#         texttemplate='%{text:.2f} %{error}',
        textfont_size=24
    )

    fig.update_xaxes(
            tickangle = 0,
            title_text = "Curriculum",
            title_font = {"size": 20},
            title_standoff = 15,
            tickfont=dict(size=14)
    )
    
    fig.update_yaxes(nticks=15)
    fig.update_yaxes(
            tickangle = 0,
            title_text = "Accuracy",
            title_font = {"size": 20},
            title_standoff = 10
    )
    
    
    #fig['layout']['yaxis'].update(range=[0, 0.9], dtick=0.01, tickformat=".3f")
    #fig['layout']['yaxis'].update(yaxis=dict(tickformat=".3f"))

    return fig

# Exemplo de uso
histories = [random_history,
      curriculum_history,
      anti_history, curriculum_historySVM, anti_historySVM, random_historySVM
]

labels = ['Random', 'Curriculum', 'Anti', 'Curriculum baseline', 'Anti baseline', 'Random baseline']
colors = ['red', 'blue', 'green', 'yellow', 'gray', 'black']
fig = bar_plot(histories, labels, colors)
fig.show()

